unit uprincipal;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, SdpoSerial, Forms, Controls, Graphics, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Buttons;

type

  { TfrmPrincipal }

  TfrmPrincipal = class(TForm)
    btnConectar: TButton;
    btnDesConectar: TButton;
    btnSalir: TButton;
    cboBitsDatos: TComboBox;
    cboPuerto: TComboBox;
    cboBaudios: TComboBox;
    cboControl: TComboBox;
    cboParidad: TComboBox;
    cboBitsStop: TComboBox;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    SdpoSerial1: TSdpoSerial;
    sbRefrescarPuertos: TSpeedButton;
    TrackBarra: TTrackBar;
    procedure btnConectarClick(Sender: TObject);
    procedure btnDesConectarClick(Sender: TObject);
    procedure btnSalirClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sbRefrescarPuertosClick(Sender: TObject);
    procedure TrackBarraChange(Sender: TObject);
  private
    { private declarations }
    procedure ConfigurarSerie();
    procedure RefrescarBotones();
  public
    { public declarations }
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

{$R *.lfm}

{ TfrmPrincipal }
uses Windows;


procedure TfrmPrincipal.TrackBarraChange(Sender: TObject);
begin
  // Enviamos el valor por puerto serie al arduino
  SdpoSerial1.WriteData(Chr(TrackBarra.Position));
end;

procedure TfrmPrincipal.ConfigurarSerie;
begin
  // Configuracion del puerto
  //
  SdpoSerial1.Device:=  cboPuerto.Text;

  case StrToInt(cboBaudios.Text) of
    300: SdpoSerial1.BaudRate := br___300;
    600: SdpoSerial1.BaudRate := br___600;
    1200: SdpoSerial1.BaudRate := br__1200;
    2400: SdpoSerial1.BaudRate := br__2400;
    4800: SdpoSerial1.BaudRate := br__4800;
    9600: SdpoSerial1.BaudRate := br__9600;
    19200: SdpoSerial1.BaudRate := br_19200;
    38400: SdpoSerial1.BaudRate := br_38400;
    57600: SdpoSerial1.BaudRate := br_57600;
    115200: SdpoSerial1.BaudRate := br115200;
    230400: SdpoSerial1.BaudRate := br230400;
    460800: SdpoSerial1.BaudRate := br460800;
    921600: SdpoSerial1.BaudRate := br921600;
  end;

  case StrToInt(cboBitsDatos.Text) of
	  5: SdpoSerial1.DataBits := db5bits;
	  6: SdpoSerial1.DataBits := db6bits;
  	7: SdpoSerial1.DataBits := db7bits;
	  8: SdpoSerial1.DataBits := db8bits;
  end;

  case cboControl.ItemIndex of
	  1: SdpoSerial1.FlowControl := fcNone;
	  2: SdpoSerial1.FlowControl := fcXonXoff;
  	3: SdpoSerial1.FlowControl := fcHardware;
  end;

  case cboParidad.ItemIndex of
	  1: SdpoSerial1.Parity := pNone;
	  2: SdpoSerial1.Parity := pOdd;
  	3: SdpoSerial1.Parity := pEven;
  	4: SdpoSerial1.Parity := pMark;
  	5: SdpoSerial1.Parity := pSpace;
  end;


  case cboBitsStop.ItemIndex of
	  1: SdpoSerial1.StopBits := sbOne;
	  2: SdpoSerial1.StopBits := sbTwo;
  end;

end;

procedure TfrmPrincipal.RefrescarBotones;
begin
  TrackBarra.Visible  	 := SdpoSerial1.Active;
  btnDesConectar.Enabled :=	SdpoSerial1.Active;
  btnConectar.Enabled 	 		 :=	not SdpoSerial1.Active;									;
  sbRefrescarPuertos.Enabled := not SdpoSerial1.Active;

end;



procedure TfrmPrincipal.btnConectarClick(Sender: TObject);
begin
  if SdpoSerial1.Active then
	  SdpoSerial1.Close;

  ConfigurarSerie();
  SdpoSerial1.Open;
  RefrescarBotones();
end;

procedure TfrmPrincipal.btnDesConectarClick(Sender: TObject);
begin
  SdpoSerial1.Close;
  RefrescarBotones();
end;



procedure TfrmPrincipal.btnSalirClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmPrincipal.FormCreate(Sender: TObject);
begin
  sbRefrescarPuertosClick(nil);
end;


procedure TfrmPrincipal.sbRefrescarPuertosClick(Sender: TObject);
var
  i : integer;
  comsconfig : COMMCONFIG;
  sizecc : cardinal;
begin

  // Obtenemos lista de puertos COM
  cboPuerto.Items.Clear;

  for i := 1 to 8 do
  begin
  {$IFDEF LINUX}
  {$IFDEF UseCThreads}
  {$ENDIF}
  {$ELSE}
  {$IFDEF WINDOWS}
	  sizecc := sizeof(commconfig);
		  if GetDefaultCommConfig( pchar('COM'+ inttostr(i)), comsconfig, sizecc) then
  {$ENDIF}
  {$ENDIF}
      cboPuerto.Items.add('COM'+ inttostr(i));
  end;


  cboPuerto.ItemIndex:=	1;
end;
end.

